import React, { Component } from "react";
import Table from "@lib/components/table";
import OptionalTime from "@lib/components/time";

export default class BannersAwapsBmc extends Component {
    renderAwapsBanners(banners, title) {
        if (typeof banners === "undefined") {
            return <div className="empty-content">User has no {title} profile</div>;
        }

        var descriptionBanner = banners[Object.keys(banners)[0]];

        var itemNames = Object.keys(descriptionBanner);
        // Displaying these names are redundant
        ["id", "name"].forEach((nameToHide) => {
            itemNames.splice(itemNames.indexOf(nameToHide), 1);
        });

        // Set proper order of columns
        var priorColumnNames = ["bm_category"];
        itemNames.forEach((itemName) => {
            if (!priorColumnNames.includes(itemName)) {
                priorColumnNames.push(itemName);
            }
        });
        itemNames = priorColumnNames;

        var sortedBanners = this.props.sorter(this.props.sortBy, banners);

        return (
            <div className="fix-table">
                <Table>
                    <thead>
                        <tr>
                            {itemNames.map((itemName) => {
                                return <th key={itemName}>{itemName}</th>;
                            })}
                        </tr>
                    </thead>
                    <tbody>
                        {sortedBanners.map(function (banner, i) {
                            return (
                                <tr key={i}>
                                    {itemNames.map((itemName) => {
                                        if (itemName === "time") {
                                            return (
                                                <td key={itemName} className="time-col">
                                                    <OptionalTime value={parseInt(banner[itemName], 10)} />
                                                </td>
                                            );
                                        } else {
                                            return <td key={itemName}>{banner[itemName]}</td>;
                                        }
                                    })}
                                </tr>
                            );
                        })}
                    </tbody>
                </Table>
            </div>
        );
    }

    render() {
        return <div>{this.renderAwapsBanners(this.props.profile, this.props.title)}</div>;
    }
}
