import React, { Component } from "react";
import FontAwesome from "react-fontawesome";
import BannersUserDirect from "./BannersUserDirect";
import BannersAwapsBmc from "./BannersAwapsBmc";
import { sortByFloat, sortByInt, sortAB } from "../utils/sorters";
import { RadioButton } from "@lib/components/lego";
import Panel from "@lib/components/panel";

import "./BannersProfile.scss";

function emptyContentInfo(title) {
    return <div className="empty-content-info">User has no {title} profile</div>;
}

const fieldRank = "rank",
    fieldBidMultiplier = "bid_multiplier",
    fieldTime = "time",
    fieldValue = "value",
    fieldBmCategory = "bm_category";

class UserDirectBannersSelectSorting extends Component {
    render() {
        return (
            <div className="select-sorting">
                <div className="sorting-label">Sort by</div>
                <FontAwesome className="sorting-label" name={this.props.glyph} onClick={this.props.switchSortOrder} />
                <RadioButton
                    size="s"
                    view="default"
                    value={this.props.value}
                    className="select-sorting"
                    onChange={(event) => this.props.handleSelect(event.target.value)}
                    options={[
                        { value: fieldRank, children: fieldRank },
                        { value: fieldBidMultiplier, children: fieldBidMultiplier },
                        { value: fieldTime, children: fieldTime },
                        { value: fieldValue, children: fieldValue },
                    ]}
                />
            </div>
        );
    }
}

class AwapsBannersSelectSorting extends Component {
    render() {
        return (
            <div className="select-sorting">
                <div className="sorting-label">Sort by</div>
                <FontAwesome className="sorting-label" name={this.props.glyph} onClick={this.props.switchSortOrder} />
                <RadioButton
                    size="s"
                    view="default"
                    value={this.props.value}
                    className="select-sorting"
                    onChange={(event) => this.props.handleSelect(event.target.value)}
                    options={[
                        { value: fieldBmCategory, children: fieldBmCategory },
                        { value: fieldTime, children: fieldTime },
                        { value: fieldValue, children: fieldValue },
                    ]}
                />
            </div>
        );
    }
}

export default class BannersProfile extends Component {
    constructor() {
        super();
        this.selectSortFieldUserDirect = this.selectSortFieldUserDirect.bind(this);
        this.switchSortOrder = this.switchSortOrder.bind(this);
        this.state = {
            radioTitle: "user-direct-banners",
            UserDirectBannersSortingField: fieldRank,
            AwapsBannersSortingField: fieldTime,
            descending: true,
        };
    }

    selectSortFieldUserDirect(fieldName) {
        this.setState({ UserDirectBannersSortingField: fieldName });
    }
    switchSortOrder() {
        this.setState({ descending: !this.state.descending });
    }

    selectSortFieldAwaps(fieldName) {
        this.setState({ AwapsBannersSortingField: fieldName });
    }

    renderOtherBanners(tableItems) {
        return (
            <div>
                <pre>{JSON.stringify(tableItems, undefined, 2)}</pre>
            </div>
        );
    }

    renderUserDirectBanners(banners, title) {
        let _this = this;
        let sorters = {
            [fieldRank]: (by, what) => {
                return sortByFloat(by, what, _this.state.descending);
            },
            [fieldTime]: (by, what) => {
                return sortByInt(by, what, _this.state.descending);
            },
            [fieldValue]: (by, what) => {
                return sortByInt(by, what, _this.state.descending);
            },
            [fieldBidMultiplier]: (by, what) => {
                return sortByFloat(by, what, _this.state.descending);
            },
        };

        return (
            <BannersUserDirect
                profile={banners}
                title={title}
                sorter={sorters[this.state.UserDirectBannersSortingField]}
                sortBy={this.state.UserDirectBannersSortingField}
                uid={this.props.uid}
            />
        );
    }

    renderAwapsBmcategories(banners, title) {
        let _this = this;
        let sorters = {
            [fieldTime]: (by, what) => {
                return sortByInt(by, what, _this.state.descending);
            },
            [fieldValue]: (by, what) => {
                return sortByInt(by, what, _this.state.descending);
            },
            [fieldBmCategory]: (by, what) => {
                return sortAB(by, what, _this.state.descending);
            },
        };
        return (
            <BannersAwapsBmc
                profile={banners}
                title={title}
                sorter={sorters[this.state.AwapsBannersSortingField]}
                sortBy={this.state.AwapsBannersSortingField}
            />
        );
    }

    renderYabsVdrf(banners, title) {
        if (typeof banners === "undefined") {
            return emptyContentInfo(title);
        }

        return <pre>{JSON.stringify(banners, undefined, 2)}</pre>;
    }

    handleRadioSelect(title) {
        this.setState({ radioTitle: title });
    }

    renderBannersTabs() {
        let profiles = this.props.profile;
        let otherBanners = [];
        const titleDirectBanners = "user-direct-banners";
        const titleAwapsBanners = "awaps-bmcategories";
        const titleYabsVdfrBanners = "yabs-vdrf";
        const titleOtherBanners = "Other";

        Object.keys(profiles).forEach((bannersTitle) => {
            if (![titleDirectBanners, titleAwapsBanners, titleYabsVdfrBanners].includes(bannersTitle)) {
                otherBanners.push(this.renderOtherBanners(profiles[bannersTitle]));
            }
        });

        const knownRenders = {
            [titleDirectBanners]: this.renderUserDirectBanners(profiles[titleDirectBanners], titleDirectBanners),
            [titleAwapsBanners]: this.renderAwapsBmcategories(profiles[titleAwapsBanners], titleAwapsBanners),
            [titleYabsVdfrBanners]: this.renderYabsVdrf(profiles[titleYabsVdfrBanners], titleYabsVdfrBanners),
            [titleOtherBanners]: <pre>{otherBanners}</pre>,
        };

        const sortOrderGlyph = this.state.descending ? "sort-amount-desc" : "sort-amount-asc";

        const knowsSelectorsRenders = {
            [titleDirectBanners]: (
                <UserDirectBannersSelectSorting
                    value={this.state.UserDirectBannersSortingField}
                    handleSelect={(field) => this.selectSortFieldUserDirect(field)}
                    glyph={sortOrderGlyph}
                    switchSortOrder={this.switchSortOrder}
                />
            ),
            [titleAwapsBanners]: (
                <AwapsBannersSelectSorting
                    value={this.state.AwapsBannersSortingField}
                    handleSelect={(field) => this.selectSortFieldAwaps(field)}
                    glyph={sortOrderGlyph}
                    switchSortOrder={this.switchSortOrder}
                />
            ),
            [titleYabsVdfrBanners]: <div className="select-sorting" />,
            [titleOtherBanners]: <div className="select-sorting" />,
        };

        return (
            <div>
                <div className="select-banners-container">
                    <RadioButton
                        view="default"
                        size="s"
                        value={this.state.radioTitle}
                        onChange={(event) => this.handleRadioSelect.bind(this)(event.target.value)}
                        className="select-banners"
                        options={[
                            { value: titleDirectBanners, children: titleDirectBanners },
                            { value: titleAwapsBanners, children: titleAwapsBanners },
                            { value: titleYabsVdfrBanners, children: titleYabsVdfrBanners },
                            { value: "Other", children: "Other" },
                        ]}
                    />
                    {knowsSelectorsRenders[this.state.radioTitle]}
                </div>
                <div className="banners-container">{knownRenders[this.state.radioTitle]}</div>
            </div>
        );
    }

    renderBannerProfile() {
        return <div>{this.renderBannersTabs()}</div>;
    }

    render() {
        const condition = typeof this.props.profile === "undefined" || Object.keys(this.props.profile).length === 0;
        return (
            <Panel>
                {condition ? (
                    <div className="empty-content">User has no banners profile</div>
                ) : (
                    this.renderBannerProfile()
                )}
            </Panel>
        );
    }
}
