import React, { Component } from "react";
import FontAwesome from "react-fontawesome";

import ModalClosable from "../common/ModalClosable";
import ActionButton from "../common/ActionButton";
import OptionalTime from "@lib/components/time";
import Link from "@lib/components/link";

import "./BannersUserDirect.scss";

const fieldRank = "rank",
    fieldBidMultiplier = "bid_multiplier",
    fieldTime = "time",
    fieldValue = "value";

class Toc extends Component {
    constructor() {
        super();
        this.handleClick = this.handleClick.bind(this);
        this.state = {
            isActive: {},
        };
    }

    componentDidMount() {
        let newState = Object.assign({}, this.state);
        this.props.tocItems.forEach((item) => {
            newState.isActive[item] = false;
        });
        this.setState(newState);
    }

    handleClick(item) {
        let newState = Object.assign({}, this.state);
        Object.keys(newState.isActive).forEach((i) => {
            newState.isActive[i] = false;
        });
        newState.isActive[item] = true;
        this.setState(newState);
    }

    render() {
        let _this = this;
        const top = "top";
        return (
            <div className="toc">
                <div className={`toc-item`} key={9999} onClick={() => _this.handleClick(top)}>
                    <a href={`#${top}`}>
                        <FontAwesome name="arrow-up" />
                    </a>
                </div>
                {this.props.tocItems.map((item) => {
                    let active = this.state.isActive[item] ? " toc-item-active" : "";
                    return (
                        <div className={`toc-item${active}`} key={item} onClick={() => _this.handleClick(item)}>
                            <a href={`#selectType${item}`}>{item}</a>
                        </div>
                    );
                })}
            </div>
        );
    }
}

export default class BannersUserDirect extends Component {
    constructor() {
        super();

        this.handleShowModal = this.handleShowModal.bind(this);
        this.handleHideModal = this.handleHideModal.bind(this);

        this.state = {
            showModalST: {},
        };
    }

    componentWillReceiveProps(nextProps) {
        let showModalST = {};

        if (typeof nextProps.profile !== "undefined") {
            showModalST[nextProps.uid] = {};

            Object.keys(nextProps.profile).forEach((profile) => {
                showModalST[profile["select_type"]] = false;
            });
        }

        this.setState({
            showModalST: showModalST,
        });
    }

    handleShowModal(selectType) {
        let showModalST = Object.assign({}, this.state.showModalST);
        showModalST[selectType] = true;
        this.setState({ showModalST: showModalST });
    }
    handleHideModal(selectType) {
        let showModalST = Object.assign({}, this.state.showModalST);
        showModalST[selectType] = false;
        this.setState({ showModalST: showModalST });
    }

    renderBanner(banner) {
        return (
            <table>
                <tbody>
                    <tr>
                        <td className="content">
                            <div className="banner-title">{banner["banner_title"]}</div>
                            <div className="banner-text">{banner["banner_text"]}</div>
                        </td>
                        <td className="info-title">
                            <div>{"select_type: "}</div>
                            <div>{`${fieldRank}: `}</div>
                            <div>{`${fieldBidMultiplier}: `}</div>
                            <div>{`${fieldValue}: `}</div>
                            <div>{`${fieldTime}: `}</div>
                        </td>
                        <td className="info-value">
                            <div>{banner["select_type"]}</div>
                            <div>{banner[fieldRank]}</div>
                            <div>{banner[fieldBidMultiplier]}</div>
                            <div>{banner[fieldValue]}</div>
                            <div>{<OptionalTime value={banner[fieldTime]} />}</div>
                        </td>
                    </tr>
                </tbody>
            </table>
        );
    }

    renderUserDirectBanners(banners, title) {
        if (typeof banners === "undefined") {
            return <div className="empty-content">User has no {title} profile</div>;
        }

        let bySelectType = {};
        banners.forEach((banner) => {
            if (!Object.keys(bySelectType).includes(banner["select_type"])) {
                bySelectType[banner["select_type"]] = [];
            }
            bySelectType[banner["select_type"]].push(banner);
        });

        let tocItems = Object.keys(bySelectType);

        return (
            <table className="user-direct-banners-layout">
                <tbody>
                    <tr>
                        {
                            // TODO: make it radio button
                        }
                        <td className="toc-container">
                            <Toc tocItems={tocItems} />
                        </td>
                        <td className="banners-container">
                            <div>
                                {Object.keys(bySelectType).map((selectType) => {
                                    let _banners = bySelectType[selectType];
                                    let modalContent = <pre>{JSON.stringify(_banners, undefined, 2)}</pre>;
                                    let descriptionBanner = _banners[Object.keys(_banners)[0]];
                                    let description = (
                                        <div>
                                            <h4>
                                                {`Select type ${descriptionBanner["select_type"]}, ${descriptionBanner["select_type_description"]}`}{" "}
                                                <ActionButton
                                                    title="JSON"
                                                    displayTitle="JSON"
                                                    onClick={() => this.handleShowModal(selectType)}
                                                    size="s"
                                                />
                                                <ModalClosable
                                                    className="modal-json"
                                                    isOpen={this.state.showModalST[selectType]}
                                                    heading={descriptionBanner["select_type_description"]}
                                                    handleHideModal={() => this.handleHideModal(selectType)}
                                                    handleShowModal={() => this.handleShowModal(selectType)}
                                                    content={modalContent}
                                                />
                                            </h4>
                                        </div>
                                    );

                                    let itemNames = Object.keys(descriptionBanner);
                                    // Displaying these names are redundant
                                    ["id", "name", "select_type", "select_type_description"].forEach((nameToHide) => {
                                        itemNames.splice(itemNames.indexOf(nameToHide), 1);
                                    });

                                    // Set proper order of columns
                                    let priorColumnNames = ["banner_title", "banner_text"];
                                    itemNames.forEach((itemName) => {
                                        if (!priorColumnNames.includes(itemName)) {
                                            priorColumnNames.push(itemName);
                                        }
                                    });
                                    itemNames = priorColumnNames;

                                    let sortedBanners = this.props.sorter(this.props.sortBy, _banners);

                                    let newBanners = sortedBanners.map((banner, index) => {
                                        return (
                                            <div className="user-direct-banner" key={index}>
                                                {this.renderBanner(banner)}
                                            </div>
                                        );
                                    });

                                    return (
                                        <div key={selectType}>
                                            <span id={`selectType${selectType}`} />
                                            {description}
                                            <div>{newBanners}</div>
                                        </div>
                                    );
                                })}
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        );
    }

    render() {
        return <div>{this.renderUserDirectBanners(this.props.profile, this.props.title)}</div>;
    }
}
