import React, { Component } from "react";
import _ from "lodash";

import Panel from "@lib/components/panel";

import "./ClicksProfile.scss";

const CLICKS_ID = "858";

class ClicksProfile extends Component {
    render() {
        const { profile } = this.props;
        const clicks = _.filter(profile["bt-counter"], (each) => each.counter_id === CLICKS_ID);
        if (_.isNull(clicks)) {
            return null;
        }
        return (
            <div className="clicks-profile">
                {clicks.map((click, i) => {
                    return (
                        <React.Fragment key={"click" + i}>
                            {_.toPairs(click.counters).map((each, j) => {
                                const key = each[0];
                                const value = each[1];
                                return <Panel key={key}>BannerGroupID {key}</Panel>;
                            })}
                        </React.Fragment>
                    );
                })}
            </div>
        );
    }
}

export default ClicksProfile;
