import React, { Component } from "react";
import { connect } from "react-redux";
import _ from "lodash";
import DoubleScrollbar from "react-double-scrollbar";
import Table from "@lib/components/table";

import OptionalTime from "@lib/components/time";
import { sortByInt, sortAB, sortByFloat } from "../utils/sorters";

import { fetchCategories } from "src/bb-profile/bm-categories/actions";

const FIELD_BM_CATEGORY_ID = "bm_category_id";
const FIELD_BM_CATEGORY = "bm_category";

const FIELD_CT_CLICKS = "clicks";
const FIELD_CT_CLICK_TIME = "click_time";
const FIELD_CT_SHOWS = "shows";
const FIELD_CT_SHOW_TIME = "show_time";
const FIELD_CT_PREMIUM_CLICKS = "premium_clicks";
const FIELD_CT_PREMIUM_CLICK_TIME = "premium_click_time";
const FIELD_CT_MOUSEOVERS = "mouseovers";
const FIELD_CT_MOUSEOVER_TIME = "mouseover_time";
const FIELD_CT_ABUSES = "abuses";
const FIELD_CT_ABUSE_TIME = "abuse_time";

const WIDTH_OF_TIME_FIELD = "201px";
const WIDTH_OF_SMALL_VALUE_FIELD = "109px";
const WIDTH_OF_WIDE_VALUE_FILED = "300px";
const styleProps = {
    [FIELD_BM_CATEGORY_ID]: { width: "139px" },
    [FIELD_BM_CATEGORY]: { width: WIDTH_OF_WIDE_VALUE_FILED },
    [FIELD_CT_CLICKS]: { width: WIDTH_OF_SMALL_VALUE_FIELD },
    [FIELD_CT_CLICK_TIME]: { width: WIDTH_OF_TIME_FIELD },
    [FIELD_CT_SHOWS]: { width: WIDTH_OF_SMALL_VALUE_FIELD },
    [FIELD_CT_SHOW_TIME]: { width: WIDTH_OF_TIME_FIELD },
    [FIELD_CT_PREMIUM_CLICKS]: { width: WIDTH_OF_SMALL_VALUE_FIELD },
    [FIELD_CT_PREMIUM_CLICK_TIME]: { width: WIDTH_OF_TIME_FIELD },
    [FIELD_CT_MOUSEOVERS]: { width: WIDTH_OF_SMALL_VALUE_FIELD },
    [FIELD_CT_MOUSEOVER_TIME]: { width: WIDTH_OF_TIME_FIELD },
    [FIELD_CT_ABUSES]: { width: WIDTH_OF_SMALL_VALUE_FIELD },
    [FIELD_CT_ABUSE_TIME]: { width: WIDTH_OF_TIME_FIELD },
};

@connect(
    (state) => ({
        bmCategories: state.bmCategories,
    }),
    (dispatch) => ({
        dispatch: dispatch,
        fetchCategories: (ids) => dispatch(fetchCategories(ids)),
    })
)
export default class CountersTable extends Component {
    constructor() {
        super();
        this.handleColumnNameClick = this.handleColumnNameClick.bind(this);

        this.state = {
            sortBy: FIELD_CT_SHOW_TIME,
            descending: {},
        };
    }

    componentWillReceiveProps(nextProps) {
        if (this.props.uid !== nextProps.uid) {
            let ids = JSON.stringify(nextProps.profile.map((item) => item.bm_category_id));
            this.props.fetchCategories(ids);
        }
    }

    componentDidMount() {
        let descending = {};
        [
            FIELD_BM_CATEGORY_ID,
            FIELD_BM_CATEGORY,
            FIELD_CT_CLICKS,
            FIELD_CT_SHOWS,
            FIELD_CT_PREMIUM_CLICKS,
            FIELD_CT_ABUSES,
            FIELD_CT_MOUSEOVERS,
        ].forEach((item) => {
            descending[item] = true;
        });

        [
            FIELD_CT_CLICK_TIME,
            FIELD_CT_ABUSE_TIME,
            FIELD_CT_SHOW_TIME,
            FIELD_CT_PREMIUM_CLICK_TIME,
            FIELD_CT_MOUSEOVER_TIME,
        ].forEach((item) => {
            descending[item] = true;
        });

        let ids = JSON.stringify(this.props.profile.map((item) => item.bm_category_id));
        this.props.fetchCategories(ids);

        this.setState({ descending: descending });
    }

    handleColumnNameClick(columnName) {
        let descending = Object.assign({}, this.state.descending);
        descending[columnName] =
            this.state.sortBy === columnName ? !this.state.descending[columnName] : this.state.descending[columnName];
        this.setState({
            sortBy: columnName,
            descending: descending,
        });
    }

    render() {
        const initialProfile = this.props.profile;
        const profile = initialProfile.map((item) => {
            if (!_.isEmpty(this.props.bmCategories.items)) {
                item["bm_category"] = this.props.bmCategories.items[item["bm_category_id"]];
            } else {
                item["bm_category"] = "";
            }

            return item;
        });

        const sorter = {
            [FIELD_BM_CATEGORY_ID]: (what) => {
                return sortByInt(FIELD_BM_CATEGORY_ID, what, this.state.descending[FIELD_BM_CATEGORY_ID]);
            },
            [FIELD_BM_CATEGORY]: (what) => {
                return sortAB(FIELD_BM_CATEGORY, what, this.state.descending[FIELD_BM_CATEGORY]);
            },
            [FIELD_CT_CLICKS]: (what) => {
                return sortByFloat(FIELD_CT_CLICKS, what, this.state.descending[FIELD_CT_CLICKS]);
            },
            [FIELD_CT_CLICK_TIME]: (what) => {
                return sortByInt(FIELD_CT_CLICK_TIME, what, this.state.descending[FIELD_CT_CLICK_TIME]);
            },
            [FIELD_CT_SHOWS]: (what) => {
                return sortByFloat(FIELD_CT_SHOWS, what, this.state.descending[FIELD_CT_SHOWS]);
            },
            [FIELD_CT_SHOW_TIME]: (what) => {
                return sortByInt(FIELD_CT_SHOW_TIME, what, this.state.descending[FIELD_CT_SHOW_TIME]);
            },
            [FIELD_CT_PREMIUM_CLICKS]: (what) => {
                return sortByFloat(FIELD_CT_PREMIUM_CLICKS, what, this.state.descending[FIELD_CT_PREMIUM_CLICKS]);
            },
            [FIELD_CT_PREMIUM_CLICK_TIME]: (what) => {
                return sortByInt(FIELD_CT_PREMIUM_CLICK_TIME, what, this.state.descending[FIELD_CT_PREMIUM_CLICK_TIME]);
            },
            [FIELD_CT_MOUSEOVERS]: (what) => {
                return sortByFloat(FIELD_CT_MOUSEOVERS, what, this.state.descending[FIELD_CT_MOUSEOVERS]);
            },
            [FIELD_CT_MOUSEOVER_TIME]: (what) => {
                return sortByInt(FIELD_CT_MOUSEOVER_TIME, what, this.state.descending[FIELD_CT_MOUSEOVER_TIME]);
            },
            [FIELD_CT_ABUSES]: (what) => {
                return sortByFloat(FIELD_CT_ABUSES, what, this.state.descending[FIELD_CT_ABUSES]);
            },
            [FIELD_CT_ABUSE_TIME]: (what) => {
                return sortByInt(FIELD_CT_ABUSE_TIME, what, this.state.descending[FIELD_CT_ABUSE_TIME]);
            },
        };

        const counters = sorter[this.state.sortBy](profile);

        return (
            <div>
                <h4>User BT Counters</h4>
                <DoubleScrollbar>
                    <Table>
                        <thead style={{ display: "block" }}>
                            <tr>
                                {[
                                    FIELD_BM_CATEGORY_ID,
                                    FIELD_BM_CATEGORY,
                                    FIELD_CT_CLICKS,
                                    FIELD_CT_CLICK_TIME,
                                    FIELD_CT_SHOWS,
                                    FIELD_CT_SHOW_TIME,
                                    FIELD_CT_PREMIUM_CLICKS,
                                    FIELD_CT_PREMIUM_CLICK_TIME,
                                    FIELD_CT_MOUSEOVERS,
                                    FIELD_CT_MOUSEOVER_TIME,
                                    FIELD_CT_ABUSES,
                                    FIELD_CT_ABUSE_TIME,
                                ].map((columnName, key) => {
                                    return (
                                        <th key={key}>
                                            <div
                                                style={styleProps[columnName]}
                                                className="counters-column-title"
                                                onClick={() => this.handleColumnNameClick(columnName)}
                                            >
                                                {columnName}
                                            </div>
                                        </th>
                                    );
                                })}
                            </tr>
                        </thead>
                        <tbody
                            style={{
                                maxHeight: "30vh",
                                overflowY: "scroll",
                                display: "block",
                            }}
                        >
                            {counters.map((item, key) => {
                                return (
                                    <tr key={key}>
                                        {[
                                            FIELD_BM_CATEGORY_ID,
                                            FIELD_BM_CATEGORY,
                                            FIELD_CT_CLICKS,
                                            FIELD_CT_CLICK_TIME,
                                            FIELD_CT_SHOWS,
                                            FIELD_CT_SHOW_TIME,
                                            FIELD_CT_PREMIUM_CLICKS,
                                            FIELD_CT_PREMIUM_CLICK_TIME,
                                            FIELD_CT_MOUSEOVERS,
                                            FIELD_CT_MOUSEOVER_TIME,
                                            FIELD_CT_ABUSES,
                                            FIELD_CT_ABUSE_TIME,
                                        ].map((columnName, key) => {
                                            let value = "";
                                            if (item[columnName] !== null && typeof item[columnName] !== "undefined") {
                                                value = item[columnName];
                                                if (
                                                    [
                                                        FIELD_CT_CLICK_TIME,
                                                        FIELD_CT_SHOW_TIME,
                                                        FIELD_CT_PREMIUM_CLICK_TIME,
                                                        FIELD_CT_MOUSEOVER_TIME,
                                                        FIELD_CT_ABUSE_TIME,
                                                    ].includes(columnName)
                                                ) {
                                                    value = <OptionalTime value={parseInt(value, 10)} />;
                                                }

                                                if (FIELD_BM_CATEGORY === columnName) {
                                                    value = <div className="counters-wide-field">{value}</div>;
                                                }
                                            }

                                            return (
                                                <td key={key} style={styleProps[columnName]}>
                                                    <div style={styleProps[columnName]}>{value}</div>
                                                </td>
                                            );
                                        })}
                                    </tr>
                                );
                            })}
                        </tbody>
                    </Table>
                </DoubleScrollbar>
            </div>
        );
    }
}
