import React, { Component } from "react";
import OptionalTime from "@lib/components/time";
import Panel from "@lib/components/panel";
import Json from "@lib/components/json";
import Label from "common/label";

import "./DevicesProfile.scss";

const emptyDeviceProfileLabel = (
    <Label style="default" className="empty-device-label">
        Empty
    </Label>
);

export default class DevicesProfile extends Component {
    renderSpecificProfile(profile, field, description, style) {
        var label, time;
        if (typeof profile === "undefined") {
            label = emptyDeviceProfileLabel;
        } else {
            label = <Label style={style}>{profile[0][field]}</Label>;
            time = <OptionalTime value={parseInt(profile[0].time, 10)} />;
        }
        return (
            <div className="device-profile">
                <div className="device-desc">
                    <p>{description}</p>
                    {label}
                    {time ? <div className="device-update-time">Updated: {time}</div> : ""}
                </div>
            </div>
        );
    }

    renderDeviceIsMobileBt(deviceProfile) {
        var label, time;
        if (typeof deviceProfile === "undefined") {
            label = emptyDeviceProfileLabel;
        } else {
            label = <Label style="primary">{deviceProfile[0]["value"] === "1" ? "True" : "False"}</Label>;
            time = <OptionalTime value={parseInt(deviceProfile[0].time, 10)} />;
        }
        return (
            <div className="device-profile">
                <div className="device-desc">
                    <p>Device is mobile:</p>
                    {label}
                    {time ? <div className="device-update-time">Updated: {time}</div> : ""}
                </div>
            </div>
        );
    }

    render() {
        var profile = this.props.profile;

        if (typeof profile === "undefined") {
            return <div className="empty-content">User has no device profile</div>;
        }

        return (
            <Panel>
                <h3>User devices</h3>
                <table className="device-profile-table">
                    <tbody>
                        <tr>
                            <td>
                                {this.renderSpecificProfile(
                                    profile["device-type-bt"],
                                    "device_type",
                                    "Device type:",
                                    "danger"
                                )}
                            </td>
                            <td>
                                {this.renderSpecificProfile(
                                    profile["detailed-device-type-bt"],
                                    "detailed_device_type",
                                    "Detailed device type:",
                                    "default"
                                )}
                            </td>
                            <td>
                                {this.renderSpecificProfile(
                                    profile["device-model-bt"],
                                    "value",
                                    "Device model:",
                                    "warning"
                                )}
                            </td>
                        </tr>
                        <tr>
                            <td>
                                {this.renderSpecificProfile(
                                    profile["device-vendor-bt"],
                                    "value",
                                    "Device vendor:",
                                    "info"
                                )}
                            </td>
                            <td>
                                {this.renderSpecificProfile(profile["os-family-bt"], "value", "OS Family:", "success")}
                            </td>
                            <td>{this.renderDeviceIsMobileBt(profile["device-is-mobile-bt"])}</td>
                        </tr>
                    </tbody>
                </table>
                <Json data={this.props.profile} />
            </Panel>
        );
    }
}
