import React, { Component } from "react";
import Panel from "@lib/components/panel";
import { isUndefined } from "lodash";
import OptionalTime from "@lib/components/time";
import Json from "@lib/components/json";

import "./style.scss";

export default class Households extends Component {
    renderHouseholdProfile() {
        if (!isUndefined(this.props.value["household"])) {
            let profiles = this.props.value["household"][0],
                profileId = profiles.id,
                profileName = profiles.name,
                updateTime = <OptionalTime value={parseInt(profiles.time, 10)} />,
                value = <Json data={profiles.value} />;
            return (
                <Panel>
                    <span>Household</span>
                    <div>{value}</div>
                    <div>
                        keyword id: {profileId}, keyword name: {profileName}, update time: {updateTime}
                    </div>
                </Panel>
            );
        }
    }

    render() {
        if (!isUndefined(this.props.value)) {
            return (
                <div className="Households">
                    <Panel>
                        <h3>Households</h3>
                        {this.renderHouseholdProfile()}
                    </Panel>
                </div>
            );
        } else {
            return <div className="empty-content">User has no households</div>;
        }
    }
}
