const SEARCH = "Search",
    CRYPTA = "Crypta",
    CLICKS = "Clicks",
    ECOM = "ECOM",
    CATEGORIES = "Categories",
    GOALS = "Goals",
    TOP_SITES = "Top sites",
    ABUSES = "Abuses",
    BANNERS = "Banners",
    DEVICES = "Devices",
    DMP = "DMP",
    GEO = "Geo",
    MOBILE = "Mobile",
    ENTITY_EXTRACTOR = "Entity Extractor",
    OTHER = "Other";

const PROFILE_NAMES = [
    SEARCH,
    CRYPTA,
    CLICKS,
    ECOM,
    CATEGORIES,
    GOALS,
    TOP_SITES,
    ABUSES,
    BANNERS,
    DEVICES,
    DMP,
    MOBILE,
    ENTITY_EXTRACTOR,
    OTHER,
];

const KW_CRYPTA_TOP_DOMAINS = "krypta-top-domains";

const VISIT_GOAL = "visit-goal";
const VISIT_GOAL_COUNTER_INFO = "counter_info";
const VISIT_GOAL_COUNTER_ID = "counter_id";

const KEYWORDS_DICT = {
    [SEARCH]: ["search-text"],
    [CRYPTA]: [
        "user-yob-bt",
        "krypta-bot-flag",
        "krypta-marketing",
        "krypta-user-gender",
        "krypta-top-yandex-services-days",
        "krypta-user-interests",
        "krypta-interest-v2",
        "krypta-adhoc-v2",
        "krypta-adhoc-v3",
        "krypta-user-revenue",
        "user-loyalty",
        "household",
        "crypta-income-5-segments",
        "crypta-user-age-6s",
    ],
    [ECOM]: ["offer-profile"],
    [CATEGORIES]: ["user-category-profile", "bt-counter"],
    [GOALS]: [VISIT_GOAL],

    [ABUSES]: ["user-bans"],
    [TOP_SITES]: [KW_CRYPTA_TOP_DOMAINS],
    [BANNERS]: ["user-direct-banners", "awaps-bmcategories", "yabs-vdrf"],
    [DEVICES]: [
        "device-model-bt",
        "device-vendor-bt",
        "device-type-bt",
        "detailed-device-type-bt",
        "device-is-mobile-bt",
        "os-family-bt",
    ],
    [DMP]: ["dmp-segment"],
    [GEO]: [
        "geo-info-reliability",
        "krypta-geolocation-precision",
        "krypta-regular-location",
        "krypta-geolocation",
        "geo-info",
        "user-region",
    ],
    [MOBILE]: ["except-apps-on-cpi", "installed-yasoft"],
    [CLICKS]: ["bt-counter"],
};

export {
    CRYPTA,
    DMP,
    GEO,
    BANNERS,
    MOBILE,
    SEARCH,
    ABUSES,
    ECOM,
    GOALS,
    CLICKS,
    CATEGORIES,
    ENTITY_EXTRACTOR,
    OTHER,
    TOP_SITES,
    DEVICES,
    PROFILE_NAMES,
    KEYWORDS_DICT,
    KW_CRYPTA_TOP_DOMAINS,
    VISIT_GOAL,
    VISIT_GOAL_COUNTER_INFO,
    VISIT_GOAL_COUNTER_ID,
};
