import React, { Component } from "react";
import { connect } from "react-redux";
import _ from "lodash";
import Table from "@lib/components/table";
import Panel from "@lib/components/panel";

import OptionalTime from "@lib/components/time";

import { fetchTargetDomainsIfNeeded } from "src/bb-profile/target-domains/actions";

@connect(
    (state) => ({
        domains: state.targetDomains,
    }),
    (dispatch) => ({
        fetchTargetDomainsIfNeeded: (ids, uid) => dispatch(fetchTargetDomainsIfNeeded(ids, uid)),
        dispatch: dispatch,
    })
)
export default class UserBans extends Component {
    componentDidMount() {
        if (!_.isUndefined(this.props.uid) && !_.isUndefined(this.props.profile)) {
            let ids = JSON.stringify(
                _.uniq(this.props.profile.map((item) => item.domainId).filter((id) => id !== "0"))
            );
            this.props.fetchTargetDomainsIfNeeded(ids, this.props.uid);
        }
    }

    render() {
        if (typeof this.props.profile === "undefined") {
            return <div className="empty-content">User has no user-bans profile</div>;
        }

        let domains = this.props.domains;

        return (
            <Panel>
                <Table>
                    <thead>
                        <tr>
                            <th>time</th>
                            <th>domain id</th>
                            <th>domain</th>
                            <th>category id</th>
                            <th>banner id</th>
                        </tr>
                    </thead>
                    <tbody>
                        {this.props.profile.map((item, i) => {
                            return (
                                <tr key={i}>
                                    <td style={{ width: "25%" }}>
                                        <OptionalTime value={parseInt(item.time, 10)} />
                                    </td>
                                    <td>{item.domainId}</td>
                                    <td>{!_.isEmpty(domains.items) ? domains.items[item.domainId] : ""}</td>
                                    <td>{item.categoryId}</td>
                                    <td>{item.bannerId}</td>
                                </tr>
                            );
                        })}
                    </tbody>
                </Table>
            </Panel>
        );
    }
}
