import React, { useState, useEffect } from "react";
import { connect } from "react-redux";
import { toPairs, isEmpty } from "lodash";
import FontAwesome from "react-fontawesome";
import Loading from "@lib/components/loading";
import Link from "@lib/components/link";

import { getActiveAdjacentUid } from "../selectors";
import { getProfileIdentifiers, getProfileIdentifiersLoading, getUidType } from "../../selectors";

import "./style.scss";
import { fetchUserIdentifiers } from "../actions";
import { getUid } from "src/selectors";
import { ALL_TO_BB_PROFILE } from "../../common/Names";
import { setInQuery } from "../../actions/router";
import { reachGoal } from "../../metrika";

const uidUrl = window.location.origin + window.location.pathname;
const getUidLink = (uid, uidType) => {
    return uidUrl + "?uid=" + uid + "&uidType=" + uidType;
};

const AdjacentUidsNavigation = connect((state) => ({
    activeAdjacentUid: getActiveAdjacentUid(state),
    uid: getUid(state),
    uidType: ALL_TO_BB_PROFILE[getUidType(state)],
    adjacentUids: getProfileIdentifiers(state),
    adjacentUidsLoading: getProfileIdentifiersLoading(state),
}))((props) => {
    const { activeAdjacentUid, adjacentUids, adjacentUidsLoading, uid, uidType, dispatch } = props;

    useEffect(() => {
        dispatch(fetchUserIdentifiers(uidType, uid));
    }, []);

    // FIXME maybe one should get proper structure from API
    let typedUids = [];
    toPairs(adjacentUids).forEach(([type, uids]) => {
        if (!isEmpty(uids)) {
            uids.forEach((id) => {
                typedUids.push([type, id]);
            });
        }
    });

    const setActiveAdjacentUid = (id, idType) => {
        dispatch(setInQuery("adjacentUid", id, false));
        dispatch(setInQuery("adjacentUidType", idType, false));
        dispatch(reachGoal("choseAdjacentUidInBbProfile"));
    };

    const isActive = (id) => id === activeAdjacentUid;
    const isMain = (id) => id === uid;

    return (
        <div className="AdjacentUidsNavigation">
            <Loading loaded={!adjacentUidsLoading} size="s">
                {typedUids.map(([type, id]) => {
                    return (
                        <span
                            className={"AdjacentUidsNavigation-item" + (!isActive(id) ? "" : "-selected")}
                            key={type + "__" + id}
                        >
                            <span
                                className={"AdjacentUidsNavigation-item-uid" + (!isMain(id) ? "" : "-main")}
                                title={type}
                                onClick={() => setActiveAdjacentUid(id, type)}
                            >
                                {id}
                            </span>
                            <Link href={getUidLink(id, type)} target="_blank">
                                <FontAwesome name="external-link" />
                            </Link>
                        </span>
                    );
                })}
            </Loading>
        </div>
    );
});

export default AdjacentUidsNavigation;
