import { createAction } from "redux-actions";
import { getBmCategories } from "src/utils/apiClient";

const requestCategories = createAction("bm categories requested");
const receiveCategories = createAction("bm categories received");

export function fetchCategories(ids) {
    return (dispatch) => {
        dispatch(requestCategories(ids));

        return getBmCategories(ids).then((response) => {
            let bmCategories;
            if (response) {
                bmCategories = response.obj;
            } else {
                bmCategories = {};
            }
            dispatch(receiveCategories(bmCategories));
        });
    };
}

export { requestCategories, receiveCategories };
