import { handleActions } from "redux-actions";
import { receiveCategories, requestCategories } from "src/bb-profile/bm-categories/actions";

const DEFAULT_STATE = {
    items: [],
    isFetching: false,
};

export const bmCategories = handleActions(
    {
        [requestCategories]: (state) => ({
            ...state,
            isFetching: true,
        }),
        [receiveCategories]: (state, { payload }) => ({
            ...state,
            items: payload,
            isFetching: false,
        }),
    },
    DEFAULT_STATE
);
