import { createAction } from "redux-actions";
import { getCommonProfile } from "src/utils/apiClient";

const requestCommonProfile = createAction("common profile requested");
const receiveCommonProfile = createAction("common profile received");
const invalidateCommonProfiles = createAction("common profile invalidated");

export function fetchCommonProfile(commonId) {
    return (dispatch) => {
        dispatch(requestCommonProfile(commonId));

        return getCommonProfile(commonId).then((response) => {
            let commonProfile = response ? response : {};
            dispatch(receiveCommonProfile(commonId, commonProfile));
        });
    };
}

export { requestCommonProfile, receiveCommonProfile, invalidateCommonProfiles };
