import { handleActions } from "redux-actions";
import {
    requestCommonProfile,
    receiveCommonProfile,
    invalidateCommonProfiles,
} from "src/bb-profile/common-profiles/actions";

const DEFAULT_STATE = {};

export const commonProfiles = handleActions(
    {
        [requestCommonProfile]: (state, { payload }) => ({
            ...state,
            [payload]: {
                isFetching: true,
                profile: {},
            },
        }),
        [receiveCommonProfile]: (state, { payload }) => ({
            [payload.commonId]: {
                isFetching: false,
                profile: payload.commonProfile,
            },
        }),
        [invalidateCommonProfiles]: () => DEFAULT_STATE,
    },
    DEFAULT_STATE
);
