import React, { Component } from "react";
import { Select } from "@lib/components/lego";

import "./UidTypeSelectInput.scss";

class UidTypeSelectInput extends Component {
    render() {
        return (
            <Select
                width="max"
                size="m"
                view="default"
                value={this.props.value}
                onChange={(event) => this.props.onChange(event.target.value)}
                options={(this.props.items || []).map((item) => ({ value: item, content: item }))}
            />
        );
    }
}

UidTypeSelectInput.defaultProps = {
    disabled: false,
};

export default UidTypeSelectInput;
