import React from "react";
import { connect } from "react-redux";
import { isUndefined } from "lodash";
import { useTranslation } from "react-i18next";
import moment from "moment";
import Loading from "@lib/components/loading";
import DataTable from "react-data-table-component";

import Panel from "@lib/components/panel";

import "./style.scss";

const EntityCounters = connect((state) => ({
    counterGroups: state.entityCounters.items,
    loading: state.entityCounters.isFetching,
}))((props) => {
    const { counterGroups, loading } = props;

    const { t } = useTranslation("bbprofile");

    const columns = [
        {
            name: "Name",
            selector: (row) => row.Name.toLowerCase(),
            cell: (row) => row.Name,
            sortable: true,
        },
        {
            name: "Value",
            selector: (row) => row.Value,
            sortable: true,
        },
        {
            name: "Age",
            selector: (row) => row.AgeSec,
            cell: (row) =>
                moment.duration(-row.AgeSec, "seconds").humanize(true),
            sortable: true,
        },
        {
            name: "ID",
            selector: (row) => parseInt(row.Id),
            sortable: true,
        },
    ];

    const customStyles = {
        rows: {
            style: {
                minHeight: "16px",
            },
        },
    };

    const renderEntityCounters = () => {
        if (!isUndefined(counterGroups)) {
            return (
                <div>
                    <h3>{t("entity_counters.title")}</h3>
                    {counterGroups.map((group, groupIndex) => {
                        return (
                            <div key={"table-" + groupIndex}>
                                <h4>
                                    {group.Description} ({group.Type})
                                </h4>
                                <h4>CounterId={group.CounterId}</h4>
                                <DataTable
                                    columns={columns}
                                    data={group.Counters}
                                    defaultSortFieldId={2}
                                    defaultSortAsc={false}
                                    customStyles={customStyles}
                                />
                            </div>
                        );
                    })}
                </div>
            );
        } else {
            return (
                <div className="EntityCounters-empty">
                    {t("entity_counters.empty")}
                </div>
            );
        }
    };

    const inner = () => {
        return (
            <Loading loaded={!loading} size="m">
                <div>{renderEntityCounters()}</div>
            </Loading>
        );
    };

    return <Panel>{inner()}</Panel>;
});

export default EntityCounters;
