import { createAction } from "redux-actions";
import { getEntityCounters } from "../../utils/apiClient";
import { addErrorNotification } from "../../utils/notifications/notificationsState";

const requestEntityCounters = createAction("entity counters requested");
const receiveEntityCounters = createAction("entity counters received");

export function fetchEntityCounters(uid, uidType) {
    return function (dispatch) {
        dispatch(requestEntityCounters());

        return getEntityCounters(uid, uidType)
            .then((response) => {
                let entityCounters = [];

                if (response) {
                    entityCounters = response.obj.EntityCounterGroups;
                }

                dispatch(receiveEntityCounters(entityCounters));
            })
            .catch((error) => {
                if (error.status && error.status !== 404) {
                    dispatch(
                        addErrorNotification(
                            error,
                            "Failed fetching target entity counters"
                        )
                    );
                }
            });
    };
}

export function shouldFetchEntityCounters(state) {
    return !state.entityCounters.isFetching;
}

export const fetchEntityCountersIfNeeded = (uid) => (dispatch, getState) => {
    if (shouldFetchEntityCounters(getState())) {
        return dispatch(fetchEntityCounters(uid));
    }
};

export { requestEntityCounters, receiveEntityCounters };
