import { handleActions } from "redux-actions";
import {
    receiveEntityCounters,
    requestEntityCounters,
} from "src/bb-profile/entity-counters/actions";

const DEFAULT_STATE = {
    isFetching: false,
    items: [],
};

export const entityCounters = handleActions(
    {
        [requestEntityCounters]: (state) => ({
            ...state,
            isFetching: true,
            items: [],
        }),
        [receiveEntityCounters]: (state, { payload }) => ({
            ...state,
            isFetching: false,
            items: payload,
        }),
    },
    DEFAULT_STATE
);
