import { handleActions } from "redux-actions";
import {
    receiveActiveProfile,
    receiveAdjacentIdentifiers,
    requestActiveProfile,
    requestAdjacentIdentifiers,
    storeCounterInfo,
} from "src/bb-profile/actions";
import { VISIT_GOAL_COUNTER_ID, VISIT_GOAL_COUNTER_INFO } from "src/bb-profile/ProfileNameConstants";
import { failActiveProfile, failAdjacentIdentifiers } from "./actions";

const DEFAULT_STATE = {
    identifiers: {
        isFetching: false,
        didFetch: false,
        uid: undefined,
        uidType: undefined,
        value: {},
        typed: [],
        error: false,
    },
    activeProfile: {
        isFetching: false,
        value: {},
        error: false,
    },
};

export const bbProfile = handleActions(
    {
        [requestActiveProfile]: (state, { payload }) => ({
            ...state,
            activeProfile: {
                isFetching: true,
                value: {},
                matching: payload,
                error: false,
            },
        }),
        [receiveActiveProfile]: (state, { payload }) => ({
            ...state,
            activeProfile: {
                isFetching: false,
                value: payload.profile,
                error: false,
            },
        }),
        [failActiveProfile]: (state) => ({
            ...state,
            activeProfile: {
                isFetching: false,
                value: {},
                error: true,
            },
        }),
        [requestAdjacentIdentifiers]: (state, { payload }) => ({
            ...state,
            identifiers: {
                isFetching: true,
                didFetch: false,
                uid: payload.idValue,
                uidType: payload.idType,
                value: {},
                typed: [],
                error: false,
            },
        }),
        [receiveAdjacentIdentifiers]: (state, { payload }) => ({
            ...state,
            identifiers: {
                isFetching: false,
                didFetch: true,
                uid: payload.idValue,
                value: payload.identifiers,
                typed: payload.typedIdentifiers,
                error: false,
            },
        }),
        [failAdjacentIdentifiers]: (state, { payload }) => ({
            ...state,
            identifiers: {
                loading: false,
                loaded: false,
                error: true,
                uid: payload.idValue,
                value: payload.identifiers,
                typed: payload.typedIdentifiers,
            },
        }),
    },
    DEFAULT_STATE
);

export const counterInfo = handleActions(
    {
        [storeCounterInfo]: (state, { payload }) => {
            let counters = {};
            payload.forEach((item) => {
                let counter = item[VISIT_GOAL_COUNTER_INFO];
                if (counter) {
                    counters[counter[VISIT_GOAL_COUNTER_ID]] = counter;
                }
            });
            return counters;
        },
    },
    {}
);
