import React, { useState } from "react";
import { isEmpty, sortBy as _sortBy } from "lodash";
import { Modal } from "@lib/components/lego";
import Table from "@lib/components/table";
import ModalHeader from "../../common/modal-header";

import "./CommonProfileModal.scss";

const FIELD_QUERY_ID = "query_id";
const FIELD_QUERY_TEXT = "query_text";
const FIELD_BITS = "bits";
const FILED_CATEGORIES = "categories";

const CommonProfileTable = (props) => {
    const { queries } = props;

    const [sortBy, setSortBy] = useState(FIELD_QUERY_ID);
    const [sortReverse, setSortReverse] = useState({
        [FIELD_QUERY_TEXT]: false,
        [FIELD_QUERY_ID]: false,
        [FIELD_BITS]: false,
        [FILED_CATEGORIES]: false,
    });

    const handleSorting = (sortByField) => {
        let sortReverseBy = { ...sortReverse };
        sortReverseBy[sortByField] = !sortReverse[sortByField];
        setSortBy(sortByField);
        setSortReverse(sortReverseBy);
    };

    const sortByFields = () => {
        _sortBy(
            queries.map(
                (query) => ({
                    [FIELD_QUERY_ID]: query.query_id,
                    [FIELD_QUERY_TEXT]: query.query_text,
                    [FIELD_BITS]: query.bits,
                    [FILED_CATEGORIES]: JSON.stringify(query.categories),
                }),
                (item) => item[sortBy]
            )
        );
    };

    const sorted = sortReverse[sortBy] ? sortByFields().reverse() : sortByFields();

    return (
        <div>
            <Table>
                <thead>
                    <tr>
                        <th className="common-profile-th" onClick={() => handleSorting(FIELD_QUERY_ID)}>
                            {FIELD_QUERY_ID}
                        </th>
                        <th className="common-profile-th" onClick={() => handleSorting(FIELD_BITS)}>
                            {FIELD_BITS}
                        </th>
                        <th className="common-profile-th" onClick={() => handleSorting(FIELD_QUERY_TEXT)}>
                            {FIELD_QUERY_TEXT}
                        </th>
                        <th className="common-profile-th" onClick={() => handleSorting(FILED_CATEGORIES)}>
                            {FILED_CATEGORIES}
                        </th>
                    </tr>
                </thead>
                <tbody>
                    {sorted.map((query, index) => {
                        return (
                            <tr key={index}>
                                <td>{query.query_id}</td>
                                <td>{query.bits}</td>
                                <td>{query.query_text}</td>
                                <td>{query.categories}</td>
                            </tr>
                        );
                    })}
                </tbody>
            </Table>
        </div>
    );
};

const CommonProfileModal = (props) => {
    const { content, visible, onClose } = props;

    const queries = isEmpty(content) ? [] : content.queries;
    const queriesTable = <CommonProfileTable queries={queries} />;

    return (
        <Modal visible={visible} onClose={onClose} theme="default">
            <ModalHeader
                title={`Common ID ${content["common_profile_id"]}, SelectType ${content["select_type"]}, Description: ${content["description"]}`}
                onClose={onClose}
                hasClose
            />
            {queriesTable}
        </Modal>
    );
};

export default CommonProfileModal;
