import { createAction } from "redux-actions";
import { getBigbProfileSettings } from "src/utils/apiClient";

export const requestSettings = createAction("profile settings requested");
export const receiveSettings = createAction("profile settings received");

export function initProfileSettings() {
    return (dispatch) => {
        dispatch(requestSettings());
        getBigbProfileSettings().then((settings) => dispatch(receiveSettings(settings)));
    };
}
