import { createAction } from "redux-actions";
import { getTargetDomains } from "../../utils/apiClient";
import { addErrorNotification } from "../../utils/notifications/notificationsState";

const requestDomains = createAction("domains requested");
const receiveDomains = createAction("domains received");

export function fetchDomains(ids, uid) {
    return function (dispatch) {
        dispatch(requestDomains());

        return getTargetDomains(ids, uid)
            .then((response) => {
                let targetDomains = {};

                if (response) {
                    targetDomains = response.obj;
                }

                dispatch(receiveDomains(targetDomains));
            })
            .catch((error) => {
                if (error.status && error.status !== 404) {
                    dispatch(addErrorNotification(error, "Failed fetching target domains"));
                }
            });
    };
}

export function shouldFetchDomains(state) {
    return !state.targetDomains.isFetching;
}

export const fetchTargetDomainsIfNeeded = (ids, uid) => (dispatch, getState) => {
    if (shouldFetchDomains(getState())) {
        return dispatch(fetchDomains(ids, uid));
    }
};

export { requestDomains, receiveDomains };
