import { handleActions } from "redux-actions";
import { receiveDomains, requestDomains } from "src/bb-profile/target-domains/actions";

const DEFAULT_STATE = {
    isFetching: false,
    items: [],
};

export const targetDomains = handleActions(
    {
        [requestDomains]: (state) => ({
            ...state,
            isFetching: true,
        }),
        [receiveDomains]: (state, { payload }) => ({
            ...state,
            isFetching: false,
            items: payload,
        }),
    },
    DEFAULT_STATE
);
