import React, { useEffect } from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import { isEmpty, sortBy as _sortBy, toPairs as _toPairs } from "lodash";

import Table from "@lib/components/table";
import Loading from "@lib/components/loading";
import { fetchTopAffinitySites } from "src/bb-profile/top-sites/actions";
import Panel from "@lib/components/panel";
import Link from "@lib/components/link";
import { getTopAffinitySitesState } from "../selectors";

import "./style.scss";

const TopAffinitySites = connect((state) => ({
    sites: getTopAffinitySitesState(state),
}))((props) => {
    const { uid, sites, dispatch } = props;

    const { t } = useTranslation("bbprofile");

    useEffect(() => {
        dispatch(fetchTopAffinitySites(uid));
    }, []);

    const renderSites = () => {
        const sorted = _sortBy(_toPairs(sites.items), (item) => item[1]).reverse();

        return (
            <>
                <h4>{t("sites.topAffinitySites")}</h4>
                <Table>
                    <thead>
                        <tr>
                            <th>URL</th>
                            <th>{t("sites.weight")}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {sorted.map((site, key) => {
                            const url = site[0];
                            return (
                                <tr key={key}>
                                    <td>
                                        <Link href={`http://${url}`}>{url}</Link>
                                    </td>
                                    <td>
                                        <div className="TopAffinitySites-weight">{site[1]}</div>
                                    </td>
                                </tr>
                            );
                        })}
                    </tbody>
                </Table>
            </>
        );
    };

    return (
        <Panel>
            <Loading loaded={!sites.isFetching} size="m">
                {!isEmpty(sites.items) ? (
                    renderSites()
                ) : (
                    <div className="TopSites-empty">{t("sites.noAffinitySites")}</div>
                )}
            </Loading>
        </Panel>
    );
});

export default TopAffinitySites;
