import React, { useEffect } from "react";
import { connect } from "react-redux";
import { isUndefined } from "lodash";
import { useTranslation } from "react-i18next";
import Table from "@lib/components/table";
import Loading from "@lib/components/loading";

import { KW_CRYPTA_TOP_DOMAINS } from "../ProfileNameConstants";
import { fetchTopSites } from "src/bb-profile/top-sites/actions";

import Panel from "@lib/components/panel";
import Link from "@lib/components/link";
import { getTopSitesState } from "../selectors";

import "./style.scss";

const TopSites = connect((state) => ({
    sites: getTopSitesState(state).items,
    loading: getTopSitesState(state).isFetching,
}))((props) => {
    const { profile, sites, loading, dispatch } = props;

    const { t } = useTranslation("bbprofile");

    useEffect(() => {
        dispatch(fetchTopSites());
    }, []);

    const renderTopSites = () => {
        if (!isUndefined(profile) && !isUndefined(profile[KW_CRYPTA_TOP_DOMAINS])) {
            const profiles = profile[KW_CRYPTA_TOP_DOMAINS],
                value = profiles[0].value;
            const domains = value.split(",");

            return (
                <div>
                    <h4>{t("sites.topDomains")}</h4>
                    <Table>
                        <thead>
                            <tr>
                                <th>URL</th>
                                <th>Domain id</th>
                            </tr>
                        </thead>
                        <tbody>
                            {domains.map((item, index) => {
                                return (
                                    <tr key={index}>
                                        <td>
                                            <Link href={"http://" + sites[item]} target="_blank">
                                                {sites[item]}
                                            </Link>
                                        </td>
                                        <td>
                                            <div className="TopSites-domain-id">{item}</div>
                                        </td>
                                    </tr>
                                );
                            })}
                        </tbody>
                    </Table>
                </div>
            );
        } else {
            return <div className="TopSites-empty">{t("sites.noDomains")}</div>;
        }
    };

    const inner = () => {
        return (
            <Loading loaded={!loading} size="m">
                <div>{renderTopSites()}</div>
            </Loading>
        );
    };

    return <Panel>{inner()}</Panel>;
});

export default TopSites;
