import { createAction } from "redux-actions";
import { getTopAffinitySites, getTopSites } from "src/utils/apiClient";
import { addErrorNotification } from "../../utils/notifications/notificationsState";

const requestTopAffinitySites = createAction("top affinity sites requested");
const receiveTopAffinitySites = createAction("top affinity sites received");
const failTopAffinitySites = createAction("fail top affinity sites");

const requestTopSites = createAction("top sites requested");
const receiveTopSites = createAction("top sites received");
const failTopSites = createAction("fail top sites");

export function fetchTopAffinitySites(uid) {
    return function (dispatch) {
        dispatch(requestTopAffinitySites(uid));

        return getTopAffinitySites(uid)
            .then((response) => {
                let sites = {};

                if (response) {
                    sites = response.obj;
                }

                dispatch(receiveTopAffinitySites(sites));
            })
            .catch((error) => {
                if (error.status && error.status === 404) {
                    dispatch(receiveTopAffinitySites({}));
                } else {
                    dispatch(failTopAffinitySites());
                    dispatch(addErrorNotification(error, "Failed to fetch top affinity sites"));
                }
            });
    };
}

export function fetchTopSites() {
    return function (dispatch) {
        dispatch(requestTopSites());

        return getTopSites()
            .then((response) => {
                let sites = {};

                if (response) {
                    sites = response.obj;
                }

                dispatch(receiveTopSites(sites));
            })
            .catch((error) => {
                if (error.status && error.status === 404) {
                    dispatch(receiveTopSites({}));
                } else {
                    dispatch(failTopSites());
                    dispatch(addErrorNotification(error, "Failed to fetch top sites dict"));
                }
            });
    };
}

export {
    requestTopAffinitySites,
    receiveTopAffinitySites,
    failTopAffinitySites,
    requestTopSites,
    receiveTopSites,
    failTopSites,
};
