import { handleActions } from "redux-actions";
import {
    failTopSites,
    receiveTopAffinitySites,
    receiveTopSites,
    requestTopAffinitySites,
    requestTopSites,
} from "src/bb-profile/top-sites/actions";
import { failTopAffinitySites } from "./actions";

const DEFAULT_STATE = {
    isFetching: false,
    items: {},
    error: false,
};

export const topAffinitySites = handleActions(
    {
        [requestTopAffinitySites]: (state) => ({
            ...state,
            items: DEFAULT_STATE.items,
            isFetching: true,
            error: DEFAULT_STATE.error,
        }),
        [receiveTopAffinitySites]: (state, { payload }) => ({
            ...state,
            items: payload,
            isFetching: false,
            error: false,
        }),
        [failTopAffinitySites]: (state) => ({
            ...state,
            items: DEFAULT_STATE.items,
            isFetching: DEFAULT_STATE.isFetching,
            error: true,
        }),
    },
    DEFAULT_STATE
);

export const topSites = handleActions(
    {
        [requestTopSites]: (state) => ({
            ...state,
            items: DEFAULT_STATE.items,
            isFetching: true,
            error: DEFAULT_STATE.error,
        }),
        [receiveTopSites]: (state, { payload }) => ({
            ...state,
            items: payload,
            isFetching: false,
            error: false,
        }),
        [failTopSites]: (state) => ({
            ...state,
            items: DEFAULT_STATE.items,
            isFetching: false,
            error: true,
        }),
    },
    DEFAULT_STATE
);
