import React, { Component } from "react";

import { Modal } from "@lib/components/lego";

import "./ModalClosable.scss";

export default class ModalClosable extends Component {
    render() {
        const { content, isOpen, handleHideModal, heading } = this.props;

        return (
            <Modal theme="normal" visible={isOpen} onClose={handleHideModal} zIndexGroupLevel={20}>
                <div className="ModalClosable">
                    <div className="ModalClosable-heading">{heading}</div>
                    <div className="ModalClosable-content">{content}</div>
                </div>
            </Modal>
        );
    }
}
