export const WIKI_URL = "https://wiki.yandex-team.ru/crypta/";
export const DOCS_URL = "https://docs.yandex-team.ru/crypta?utm_source=portal";
export const NDA_URL = "https://wiki.yandex-team.ru/nda";
export const CRYPTA_DEV_EMAIL = "krypta-dev@yandex-team.ru";
export const BB_VIEWER_URL = "https://bb-viewer.yandex-team.ru/profile";
export const CRYPTA_SEARCH_URL = "https://search.crypta.yandex-team.ru";

// All identifiers
export const COMMON_YANDEXUID = "yandexuid";
export const COMMON_PUID = "puid";
export const COMMON_IDFA = "idfa";
export const COMMON_GAID = "gaid";
export const COMMON_OAID = "oaid";
export const COMMON_MM_DEVICE_ID = "mm_device_id";
export const COMMON_IFV = "ifv";
export const COMMON_UUID = "uuid";
export const COMMON_XUNIQ_GUID = "xuniq_guid";
export const COMMON_DUID = "duid";
export const COMMON_ICOOKIE = "icookie";
export const COMMON_CRYPTA_ID = "crypta_id";

// TODO: too much copy-paste, need to use single id representation at client side

export const COMMON_IDS_FOR_PROFILES = [
    COMMON_YANDEXUID,
    COMMON_PUID,
    COMMON_IDFA,
    COMMON_GAID,
    COMMON_OAID,
    COMMON_MM_DEVICE_ID,
    COMMON_IFV,
    COMMON_UUID,
    COMMON_XUNIQ_GUID,
    COMMON_DUID,
    COMMON_ICOOKIE,
    COMMON_CRYPTA_ID,
];

export const COMMON_TO_BIGB_ID_MAP = {
    [COMMON_YANDEXUID]: "bigb-uid",
    [COMMON_PUID]: "puid",
    [COMMON_IDFA]: "idfa",
    [COMMON_GAID]: "gaid",
    [COMMON_OAID]: "oaid",
    [COMMON_MM_DEVICE_ID]: "mm-device-id",
    [COMMON_IFV]: "ifv",
    [COMMON_UUID]: "uuid",
    [COMMON_XUNIQ_GUID]: "bigb-uid",
    [COMMON_DUID]: "duid",
    [COMMON_ICOOKIE]: "icookie",
    [COMMON_CRYPTA_ID]: "crypta-id",
};

export const COMMON_TO_BIGB_API_ID_MAP = {
    [COMMON_YANDEXUID]: "BIGB_UID",
    [COMMON_PUID]: "PUID",
    [COMMON_IDFA]: "IDFA",
    [COMMON_GAID]: "GAID",
    [COMMON_OAID]: "OAID",
    [COMMON_MM_DEVICE_ID]: "MM_DEVICE_ID",
    [COMMON_IFV]: "IFV",
    [COMMON_UUID]: "UUID",
    [COMMON_XUNIQ_GUID]: "BIGB_UID",
    [COMMON_DUID]: "DUID",
    [COMMON_ICOOKIE]: "ICOOKIE",
    [COMMON_CRYPTA_ID]: "CRYPTA_ID",
};

export const ALL_TO_BB_PROFILE = {
    yandexuid: "yandexuid",
    uuid: "uuid",
    puid: "puid",
    idfa: "idfa",
    gaid: "gaid",
    oaid: "oaid",
    mm_device_id: "mm_device_id",
    ifv: "ifv",
    uuid: "uuid",
    mac: "yandexuid", // WTF
    private_yandexuid: "yandexuid",
    crypta_id1: "yandexuid", // WTF
    xuniq_guid: "xuniq_guid",
    duid: "duid",
    crypta_id: "crypta_id",
};

export const GRAPH_V2_CUSTOM_PATH = "v2_custom_path";
