import React from "react";

import "./style.scss";

const Chapters = (props) => {
    const { values, active, onSelect } = props;

    return (
        <div className="Chapters">
            {values.map((chapter, key) => {
                return (
                    <ChapterPad
                        title={chapter.title}
                        value={chapter.value}
                        isActive={active === chapter.value}
                        onClick={() => onSelect(chapter.value)}
                        key={key}
                    />
                );
            })}
        </div>
    );
};

const ChapterPad = (props) => {
    const { isActive, value, title, onClick } = props;

    const activeClass = isActive ? "Chapter-pad-active" : "";
    return (
        <div className={`Chapter-pad ${activeClass}`} onClick={() => onClick(value)}>
            {title}
        </div>
    );
};

export default Chapters;
