import React, { Component } from "react";
import Label from "common/label";
import FontAwesome from "react-fontawesome";
import ReactTooltip from "react-tooltip";

import "./CollapseLabel.scss";

class CollapseLabel extends Component {
    render() {
        const glyph = this.props.expanded ? "chevron-up" : "chevron-down";

        return (
            <div className="collapse-label-wrapper">
                <span data-tip={this.props.message}>
                    <Label className="collapse-label" onClick={this.props.onClick}>
                        <FontAwesome name={glyph} />
                    </Label>
                </span>
                <ReactTooltip />
            </div>
        );
    }
}

export default CollapseLabel;
