import React, { Component } from "react";
import CollapseLabel from "../collapse-label/CollapseLabel";

import "./style.scss";

class AdditionalSettingsPanel extends Component {
    constructor() {
        super();
        this.handleCollapseLabelClick = this.handleCollapseLabelClick.bind(this);

        this.state = {
            expanded: false,
        };
    }

    handleCollapseLabelClick() {
        this.setState({ expanded: !this.state.expanded });
    }

    render() {
        const hiddenSettings = this.state.expanded ? "" : "settings-table-hidden";
        const settings = <div className={`settings-table ${hiddenSettings}`}>{this.props.content}</div>;
        const message = this.state.expanded ? "Show less" : "Show more";

        return (
            <div className="additional-setting-container">
                <div className="settings-upper-border" />
                <CollapseLabel
                    expanded={this.state.expanded}
                    onClick={this.handleCollapseLabelClick}
                    message={message}
                />
                {settings}
            </div>
        );
    }
}

export default AdditionalSettingsPanel;
