import React, { Component } from "react";
import { NavLink as RouterLink } from "react-router-dom";
import { connect } from "react-redux";
import { withRouter } from "react-router-dom";
import FontAwesome from "react-fontawesome";

import { CRYPTA_SEARCH_URL, DOCS_URL } from "../Names";
import { getSearch, getPath, getUid, getUidType } from "selectors";
import { dropQuery, reload } from "src/actions/router";
import { truncateLongerThan } from "@lib/utils/safety";
import CryptaLogo from "@lib/components/logo";
import Link from "@lib/components/link";
import { Icon } from "@lib/components/lego";

import SimpleLogo from "@lib/images/simple_logo.svg";

import "./AppHeader.scss";

const PATH_TO_NAME = {
    "/me": "Basic",
    "/geo": "Geo",
    "/graph": "Graph",
    "/ads": "Ads",
    "/profiles": "Profiles",
    "/new": "New",
};

function QueryUid(props) {
    const uidType = props.uidType || "type";
    const uid = props.uid || "id";
    return (
        <div className="AppHeader__menu-query-item">
            <div className="query-label">{uidType}</div>
            <div className="query-value">{truncateLongerThan(uid, 25)}</div>
        </div>
    );
}

function QueryScope(props) {
    const scope = (PATH_TO_NAME[props.path] || "default").toLowerCase();
    return (
        <div className="AppHeader__menu-query-item">
            <div className="query-label">scope</div>
            <div className="query-value">{scope}</div>
        </div>
    );
}

function ClearButton(props) {
    return (
        <span className="clear" onClick={props.onClick}>
            <Icon glyph="type-cross-websearch" />
        </span>
    );
}

function CryptaSearchLink(props) {
    let url = `${CRYPTA_SEARCH_URL}/?query=${props.uidType} ${props.uid}`;
    return (
        <div className="AppHeader__menu-item">
            <Link href={url}>
                Search
            </Link>
        </div>
    );
}

function Suggestions(props) {
    return Object.entries(PATH_TO_NAME).map((entry) => {
        const [path, name] = entry;
        return (
            <RouterLink key={name} className="AppHeader__menu-item" to={{ pathname: path, search: props.search }}>
                {name}
            </RouterLink>
        );
    });
}

@withRouter
@connect((state) => ({
    search: getSearch(state),
    uid: getUid(state),
    uidType: getUidType(state),
    path: getPath(state),
}))
export default class AppHeader extends Component {
    render() {
        const { search, uid, uidType, path, dispatch } = this.props;

        return (
            <div className="AppHeader">
                <div className="AppHeader__left-pane">
                </div>
                <div className="AppHeader__middle-pane">
                    <div className="AppHeader__menu">
                        <img className="simpleLogo" src={ SimpleLogo } />
                        <QueryUid uid={uid} uidType={uidType} />
                        <QueryScope path={path} />
                        <div style={{ flex: "auto" }} />
                        <Suggestions search={search} />
                        <CryptaSearchLink uid={uid} uidType={uidType} />
                        <ClearButton onClick={() => dispatch(dropQuery())} />
                    </div>
                </div>
                <div className="AppHeader__right-pane">
                </div>
            </div>
        );
    }
}
