import React, { Component } from "react";
import FontAwesome from "react-fontawesome";
import Link from "@lib/components/link";

import "./UrlLink.scss";

const LINK_TYPE_EXTERNAL = "external";
const LINK_TYPE_SHARE = "share";

const LINK_THEME_LIGHT = "light";
const LINK_THEME_DARK = "dark";

const CLASS_BASENAME = "portal-url-link";

class UrlLink extends Component {
    render() {
        let { type, theme, url, text } = this.props;
        let glyph;
        let altText;

        switch (type) {
            case LINK_TYPE_SHARE:
                glyph = "link";
                altText = "Link to this page";
                break;
            case LINK_TYPE_EXTERNAL:
            default:
                glyph = "external-link";
                altText = "Open in new window";
                break;
        }

        return (
            <div className={`${CLASS_BASENAME}  ${CLASS_BASENAME}-${type} ${CLASS_BASENAME}-${theme}`}>
                <Link href={url} target="_blank" title={altText}>
                    <FontAwesome name={glyph} /> {text}
                </Link>
            </div>
        );
    }
}

UrlLink.defaultProps = {
    type: LINK_TYPE_SHARE,
    theme: LINK_THEME_DARK,
};

export default UrlLink;
