import React from "react";
import PropTypes from "prop-types";

import "./style.scss";
import { useTranslation } from "react-i18next";

const ModalHeader = (props) => {
    const { title, info, hasClose, onClose } = props;

    const { t } = useTranslation("common");

    return (
        <div className="ModalHeader-container">
            <span className="ModalHeader-title">{title}</span>
            <span className="ModalHeader-right">
                {info && <span className="ModalHeader-info">{info}</span>}
                {hasClose && (
                    <span className="ModalHeader-close" onClick={onClose} title={t("actions.close")}>
                        ⨉
                    </span>
                )}
            </span>
        </div>
    );
};

ModalHeader.propTypes = {
    title: PropTypes.string.isRequired,
    info: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    hasClose: PropTypes.bool,
    onClose: PropTypes.func,
};

ModalHeader.defaultProps = {
    hasClose: false,
};

export default ModalHeader;
