import React, { Component } from "react";
import PointEvaluation from "./PointEvaluation";
import OptionalTime from "@lib/components/time";
import ActionButton from "../common/ActionButton";
import ModalClosable from "../common/ModalClosable";

import "./StatusBar.scss";

export default class GeoInfoBar extends Component {
    constructor() {
        super();

        this.handleShowGeoEval = this.handleShowGeoEval.bind(this);
        this.handleHideGeoEval = this.handleHideGeoEval.bind(this);

        this.state = {
            showModal: false,
        };
    }

    handleShowGeoEval() {
        this.setState({ showModal: true });
    }

    handleHideGeoEval() {
        this.setState({ showModal: false });
    }

    render() {
        const info = this.props.value;
        let updateTime = "Unknown";
        let evalGeoButton = <div />;

        if (typeof info !== "undefined") {
            if (typeof info.updateTime !== "undefined") {
                updateTime = <OptionalTime value={parseInt(info.updateTime, 10)} />;
            }

            if (["Home", "Work", "Regular"].includes(info.type)) {
                evalGeoButton = (
                    <div className="geo-eval-button">
                        <ActionButton
                            onClick={() => this.handleShowGeoEval()}
                            title="Confirm point accuracy"
                            displayTitle="Validate point"
                        />
                        <ModalClosable
                            className="modal-json"
                            isOpen={this.state.showModal}
                            heading={`Specify type of this point`}
                            handleHideModal={() => this.handleHideGeoEval()}
                            handleShowModal={() => this.handleShowGeoEval()}
                            content={
                                <div>
                                    <pre>{JSON.stringify(info, undefined, 2)}</pre>
                                    <PointEvaluation yandexuid={this.props.uid} info={info} />
                                </div>
                            }
                        />
                    </div>
                );
            }
        }

        return (
            <div className="status-bar">
                <div className="point-info">
                    {info ? (
                        <div>
                            {`Type: ${info.type} \u00a0\u00a0`}
                            {"Update time: "}
                            {updateTime}
                            {"\u00a0\u00a0 "}
                            {` Point: ${info.latitude}, ${info.longitude}`}
                            {evalGeoButton}
                        </div>
                    ) : (
                        "Click on marker to see point info"
                    )}
                </div>
            </div>
        );
    }
}
