import React, { Component } from "react";
import ActionButton from "../common/ActionButton";
import { evalGeo } from "../utils/apiClient";
import LoadingSpinner from "../common/LoadingSpinner";
import { Radiobox } from "@lib/components/lego";

const POINT_TYPE_HOME = {
    HOME_HERE: "My home is exactly here",
    HOME_QUITE_CLOSE: "My home is < 100m close to the point",
    HOME_CLOSE: "My home is < 1km close to the point",
    STAYS_REGULARLY: "I stay here regularly but this is not home",
    CHECKS_IN_REGULARLY: "I check in here regularly (shopping, gas station, friends' home, etc.)",
    VISITED_LONG: "I stayed here for long time (vacation, business trip, etc.)",
    VISITED_ONCE: "I've been here once or twice",
    NOT_VISITED: "I didn't visit this place in last 45 days",
    NOT_VISITED_EVER: "I never visited this place",
    VISITED_BY_FRIEND: "I don't visit this place but my friend/relative does",
    PASS_BY_REGULARLY: "I often pass by this place (e.g. my favourite traffic jam, some point on familiar route)",
};

const POINT_TYPE_WORK = {
    WORK_HERE: "My work is exactly here",
    WORK_QUITE_CLOSE: "My work is < 100m close to the point",
    WORK_CLOSE: "My work is < 1km close to the point",
    STAYS_REGULARLY: "I stay here regularly but this is not work",
    CHECKS_IN_REGULARLY: "I check in here regularly (shopping, gas station, friends' home, etc.)",
    VISITED_LONG: "I stayed here for long time (vacation, business trip, etc.)",
    VISITED_ONCE: "I've been here once or twice",
    NOT_VISITED: "I didn't visit this place in last 45 days",
    NOT_VISITED_EVER: "I never visited this place",
    VISITED_BY_FRIEND: "I don't visit this place but my friend/relative does",
    PASS_BY_REGULARLY: "I often pass by this place (e.g. my favourite traffic jam, some point on familiar route)",
};

const POINT_TYPE_REGULAR = {
    STAYS_REGULARLY: "I stay here regularly (home or work)",
    CHECKS_IN_REGULARLY: "I check in here regularly (shopping, gas station, friends' home, etc.)",
    VISITED_LONG: "I stayed here for long time (vacation, business trip, etc.)",
    VISITED_ONCE: "I've been here once or twice",
    NOT_VISITED: "I didn't visit this place in last 45 days",
    NOT_VISITED_EVER: "I never visited this place",
    VISITED_BY_FRIEND: "I don't visit this place but my friend/relative does",
    PASS_BY_REGULARLY: "I often pass by this place (e.g. my favourite traffic jam, some point on familiar route)",
};

const POINT_TYPE = {
    Home: POINT_TYPE_HOME,
    Work: POINT_TYPE_WORK,
    Regular: POINT_TYPE_REGULAR,
};

const loadingIndicator = (
    <div>
        <div style={{ marginRight: "15px", display: "inline" }}>
            <LoadingSpinner size="s" />
        </div>
        <div style={{ display: "inline" }}>Sending to storage...</div>
    </div>
);

class PointEvaluation extends Component {
    constructor() {
        super();
        this.handleSelect = this.handleSelect.bind(this);
        this.handleConfirmChoice = this.handleConfirmChoice.bind(this);

        this.state = {
            pointChosen: undefined,
            showRadio: true,
            error: undefined,
            evalPending: false,
        };
    }

    handleSelect(value) {
        this.setState({ pointChosen: value });
    }

    handleConfirmChoice() {
        const yandexuid = this.props.yandexuid;
        const latitude = this.props.info.latitude.toFixed(8);
        const longitude = this.props.info.longitude.toFixed(8);
        const state = this.state.pointChosen;
        const location = this.props.info.type.toUpperCase();
        const timestamp = Math.round(Date.now() / 1000);

        this.setState({ evalPending: true }, () => {
            evalGeo(yandexuid, latitude, longitude, state, location, timestamp)
                .then((response) => {
                    this.setState({ showRadio: false, evalPending: false });
                })
                .catch((e) => {
                    console.error("Cant send evaluation to the server.");
                    this.setState({
                        showRadio: false,
                        evalPending: false,
                        error: "Something went wrong",
                    });
                });
        });
    }

    render() {
        return (
            <div className="radio-point-eval">
                {this.state.showRadio ? (
                    <div>
                        <Radiobox
                            value={this.state.pointChosen}
                            size="s"
                            view="default"
                            onChange={(event) => this.handleSelect(event.target.value)}
                            options={Object.keys(POINT_TYPE[this.props.info.type]).map((pointType) => ({
                                value: pointType,
                                label: POINT_TYPE[this.props.info.type][pointType],
                            }))}
                        />
                        <div>
                            <ActionButton
                                onClick={() => this.handleConfirmChoice()}
                                title="Confirm choice"
                                displayTitle="Confirm choice"
                                disabled={!this.state.pointChosen}
                            />
                            <div className={"loading-eval"}>{this.state.evalPending ? loadingIndicator : ""}</div>
                        </div>
                    </div>
                ) : (
                    <div className={"point-confirmation-info"}>
                        {this.state.error ? this.state.error : "Your evaluation accepted. Thank You!"}
                    </div>
                )}
            </div>
        );
    }
}

export default PointEvaluation;
