import { createAction } from "redux-actions";
import { fetchUserIdentifiers } from "src/bb-profile/actions";
import { getUserProfile } from "src/utils/apiClient";
import { COMMON_TO_BIGB_API_ID_MAP } from "src/common/Names";
import { addErrorNotification, dropAllNotifications } from "../utils/notifications/notificationsState";

export const invalidateGeo = createAction("@@geo/INVALIDATE");
export const requestGeo = createAction("@@geo/REQUEST");
export const receiveGeo = createAction("@@geo/RECEIVE");

const ACTUAL_LOCATION_FIELD = "krypta-geolocation";
const REGULAR_LOCATION_FIELD = "krypta-regular-location";

export function fetchGeo(uidType, uid) {
    return (dispatch) => {
        dispatch(dropAllNotifications());

        dispatch(fetchUserIdentifiers(uidType, uid))
            .then((identifiers) => {
                dispatch(requestGeo(uid));
                return getUserProfile(COMMON_TO_BIGB_API_ID_MAP[uidType], uid);
            })
            .then((response) => {
                let locations = {};
                const profile = response.obj.data[0]["segment"];

                let actual = profile.filter((segment) => {
                    return segment.name === ACTUAL_LOCATION_FIELD;
                });
                locations[ACTUAL_LOCATION_FIELD] = actual ? actual[0] : {};

                let regular = profile.filter((segment) => {
                    return segment.name === REGULAR_LOCATION_FIELD;
                });
                locations[REGULAR_LOCATION_FIELD] = regular ? regular[0] : {};
                dispatch(receiveGeo(locations));
            })
            .catch((error) => {
                if (error.status && error.status !== 404) {
                    dispatch(addErrorNotification(error, "Failed to fetch geo"));
                }
            });
    };
}

function shouldFetchGeo(state) {
    return !state.geo.fetching;
}

export function fetchGeoIfNeeded(uidType, uid) {
    return (dispatch, getState) => {
        if (shouldFetchGeo(getState())) {
            return dispatch(fetchGeo(uidType, uid));
        } else {
            return Promise.resolve();
        }
    };
}
