import { handleActions } from "redux-actions";
import { receiveGeo, requestGeo } from "src/geo/actions";

export const geoReducer = handleActions(
    {
        [requestGeo]: (state) => ({
            ...state,
            fetching: true,
        }),
        [receiveGeo]: (state, { payload }) => ({
            ...state,
            locations: payload,
            fetching: false,
        }),
    },
    {
        locations: [],
        fetching: false,
    }
);
