import React, { Component } from "react";
import { Tab, Tabs, TabList, TabPanel } from "react-tabs";
import Panel from "@lib/components/panel";
import { statusColors } from "../viewer/style/diffColorMap";
import Copyable from "@lib/components/copyable";
import Link from "@lib/components/link";

import "./ComponentInfo.scss";

export default class ComponentInfo extends Component {
    render() {
        let cryptaIds = Object.keys(this.props.componentsInfo);

        const cryptaIdsList = (
            <div>
                {cryptaIds.map((cryptaId) => {
                    let selectedClass = cryptaId === this.props.selectedCryptaId ? "selected-crypta-id" : "";
                    return (
                        <h4 key={cryptaId}>
                            <Link className={selectedClass} onClick={() => this.props.onSelectCryptaId(cryptaId)}>
                                {cryptaId}
                            </Link>
                        </h4>
                    );
                })}
            </div>
        );

        return (
            <Panel>
                <h4>CryptaId</h4>
                {cryptaIdsList}
                {this.mergeMetricsTree(this.props.selectedCryptaId)}
                {this.componentDetails(this.props.selectedCryptaId)}
            </Panel>
        );
    }

    mergeMetricsTree(selectedCryptaId) {
        if (selectedCryptaId) {
            let selectedComponent = this.props.componentsInfo[selectedCryptaId];
            if (selectedComponent.hasOwnProperty("metricsTree")) {
                let metricsTree = Object.entries(selectedComponent.metricsTree.children).map((values, key) => {
                    return `  ${values[0]}: ${parseFloat(values[1].toFixed(10))}\n`;
                });
                return (
                    <div>
                        <pre>
                            vertices count: {selectedComponent.verticesCount}
                            <br />
                            neighbours count: {selectedComponent.neighboursCount}
                            <br />
                            <details>
                                <summary>score: {parseFloat(selectedComponent.metricsTree.score.toFixed(10))}</summary>
                                {metricsTree}
                            </details>
                        </pre>
                    </div>
                );
            }
        }
        return <div />;
    }

    componentDetails(selectedCryptaId) {
        if (selectedCryptaId) {
            let selectedComponent = this.props.componentsInfo[selectedCryptaId];
            let entries = Object.entries(selectedComponent.idList);

            return (
                <div className="component-details">
                    <Tabs>
                        <TabList>
                            {entries.map(([idType, idValues], key) => (
                                <Tab key={idType}>{idType + " (" + idValues.length + ")"}</Tab>
                            ))}
                        </TabList>
                        {entries.map(([idType, idValues], key) => (
                            <TabPanel key={idType}>
                                <div>{idValues.map((v, key) => this.renderId(v, key))}</div>
                            </TabPanel>
                        ))}
                    </Tabs>
                </div>
            );
        } else {
            return <div />;
        }
    }

    renderId(v, key) {
        let diffStyle = this.props.diffIds ? { color: statusColors[v.status] } : {};
        return (
            <div key={key} style={diffStyle} title={v.status}>
                <Copyable value={v.idValue} />
            </div>
        );
    }
}
