import React, { Component } from "react";
import Panel from "@lib/components/panel";
import "./IdInfo.scss";
import { DatesDetails } from "./InfoDetails";

export default class EdgeInfo extends Component {
    render() {
        let edge = this.props.selectedEdge;

        let attrs;
        if (edge.attributes !== undefined && edge.attributes.length !== 0) {
            attrs = <div>Attributes: {edge.attributes.join(",")}</div>;
        }

        let survivalWeight;
        if (edge.weight) {
            survivalWeight = <div>SurvivalWeight: {parseFloat(edge.weight.toPrecision(12))}</div>;
        }
        let weightBetweenComponents;
        if (edge.weightBetweenComponents) {
            weightBetweenComponents = (
                <div>WeightBetweenComponents: {parseFloat(edge.weightBetweenComponents.toPrecision(12))}</div>
            );
        }
        let strength;
        if (edge.strength) {
            strength = <div>Strength: {edge.strength}</div>;
        }
        let status;
        if (edge.strength) {
            status = <div>Status: {edge.status}</div>;
        }
        let scoreGain;
        if (edge.scoreGain) {
            let scoreGainChildren = Object.entries(edge.scoreGain.children).map((values, key) => {
                return `  ${values[0]}: ${parseFloat(values[1].toFixed(10))}\n`;
            });
            scoreGain = (
                <details>
                    <summary>ScoreGain: {parseFloat(edge.scoreGain.score.toPrecision(12))}</summary>
                    {scoreGainChildren}
                </details>
            );
        }
        let similarityResults;
        if (edge.similarityResults) {
            let results = edge.similarityResults.map(
                (similarityResult) => `  ${similarityResult.similarityType}: ${similarityResult.similar}\n`
            );
            similarityResults = (
                <details>
                    <summary>SimilarityResults</summary>
                    {results}
                </details>
            );
        }
        return (
            <Panel>
                <div>
                    <h4>Selected edge</h4>
                    <pre>
                        Id1: {edge.source.idValue}
                        <br />
                        Id2: {edge.target.idValue}
                        <br />
                        Source: {edge.sourceType}_{edge.logSource}
                        {attrs}
                        {survivalWeight}
                        {weightBetweenComponents}
                        {strength}
                        {status}
                        {scoreGain}
                        {similarityResults}
                    </pre>

                    <DatesDetails dates={edge.dates} />
                </div>
            </Panel>
        );
    }
}
