import React, { Component } from "react";
import Panel from "@lib/components/panel";

import "./IdInfo.scss";
import { equals, getShortInfo } from "./vertexId";
import { DatesDetails, JsonDetails } from "./InfoDetails";
import _ from "lodash";
import { connect } from "react-redux";
import { fetchAdditionalIdInfo } from "src/graph/info/actions";

@connect(
    (state) => ({
        idsAdditionalInfo: state.idInfo.idsAdditionalInfo,
    }),
    (dispatch) => ({
        tryFetchAdditionalInfo: (selectedId) => dispatch(fetchAdditionalIdInfo(selectedId)),
    })
)
export default class IdInfo extends Component {
    render() {
        let shortInfo = getShortInfo(this.props.selectedId, this.props.idsInfo).map((item) => (
            <div key={item.label}>
                {item.label}: {item.info}
                <br />
            </div>
        ));

        return (
            <Panel>
                <div>
                    <h4>Selected id</h4>
                    <pre>
                        Id: {this.props.selectedId.idValue}
                        <br />
                        Type: {this.props.selectedId.idType}
                        <br />
                        {shortInfo}
                    </pre>

                    {this.renderDetails(this.props.selectedId)}
                    {this.renderAdditionalInfo(this.props.selectedId)}
                </div>
            </Panel>
        );
    }

    renderDetails(selectedId) {
        let selectedIdInfo = this.props.idsInfo.find((idInfo) => equals(idInfo.id, selectedId));
        let maybeSelectedIdDetails = selectedIdInfo && selectedIdInfo.info;

        if (maybeSelectedIdDetails) {
            const selectedIdDetails = { ...maybeSelectedIdDetails };

            let dates = _.get(selectedIdDetails, "dates");
            let datesDetails;
            if (dates) {
                selectedIdDetails.dates = undefined; // don't show in details twice
                datesDetails = <DatesDetails dates={dates} />;
            } else {
                datesDetails = <div />;
            }

            let jsonDetails = <JsonDetails data={selectedIdDetails} filterEmptyValues={true} />;

            return (
                <div>
                    {jsonDetails}
                    {datesDetails}
                </div>
            );
        } else {
            return <div />;
        }
    }

    renderAdditionalInfo(selectedId) {
        let details;

        let key = [selectedId.idValue, selectedId.idType];
        let existingAdditionalInfo = this.props.idsAdditionalInfo[key];
        if (existingAdditionalInfo === undefined) {
            details = <pre>Loading...</pre>;
        } else {
            details = <pre className="detailsInner">{existingAdditionalInfo}</pre>;
        }

        return (
            <details>
                <summary onClick={() => this.props.tryFetchAdditionalInfo(selectedId)}>Get additional info</summary>
                {details}
            </details>
        );
    }
}
