import React, { Component } from "react";

export class InfoDetails extends Component {
    render() {
        return (
            <details>
                <summary>{this.props.title}</summary>
                <pre className="detailsInner">{this.props.info}</pre>
            </details>
        );
    }
}

export class JsonDetails extends Component {
    filterEmptyValues(obj) {
        let filteredByValueKeys = Object.keys(obj).filter((key) => obj[key] !== null && obj[key] !== "");
        return Object.assign(...filteredByValueKeys.map((key) => ({ [key]: obj[key] })));
    }

    render() {
        let data = this.props.data;
        if (this.props.filterEmptyValues) {
            data = this.filterEmptyValues(data);
        }
        let jsonDetails = JSON.stringify(data, null, 2);
        return <InfoDetails title="Details" info={jsonDetails} />;
    }
}

export class DatesDetails extends Component {
    render() {
        let datesList = this.props.dates.map((date) => <li key={date}>{date}</li>);
        let datesUl = <ul>{datesList}</ul>;
        return <InfoDetails title="Dates" info={datesUl} />;
    }
}
