import React, { Component } from "react";
import { connect } from "react-redux";
import { COMPONENT_INFO_MODE, EDGE_INFO_MODE, ID_INFO_MODE } from "../selectReducers";
import IdInfo from "./IdInfo";
import EdgeInfo from "./EdgeInfo";
import ComponentInfo from "./ComponentInfo";
import { selectCryptaId } from "../selectActions";
import { equals } from "./vertexId";
import { getGraphParameters } from "selectors";

class InfoPanel extends Component {
    render() {
        if (this.props.infoPanelMode === ID_INFO_MODE) {
            return <IdInfo selectedId={this.props.selectedId} idsInfo={this.props.idsInfo} />;
        } else if (this.props.infoPanelMode === EDGE_INFO_MODE) {
            return <EdgeInfo selectedEdge={this.props.selectedEdge} />;
        } else if (this.props.infoPanelMode === COMPONENT_INFO_MODE) {
            return (
                <ComponentInfo
                    componentsInfo={this.props.componentsInfo}
                    selectedCryptaId={this.props.selectedCryptaId}
                    onSelectCryptaId={(cryptaId) => this.props.onSelectCryptaId(cryptaId)}
                    diffIds={this.props.showDiff}
                />
            );
        } else {
            return <div />;
        }
    }
}

const mapStateToProps = (state) => {
    return {
        selectedId: state.select.selectedId,
        selectedEdge: state.select.selectedEdge,
        selectedCryptaId: state.select.selectedCryptaId,
        infoPanelMode: state.select.infoPanelMode,
        componentsInfo: state.graphInfo.componentsInfo,
        idsInfo: state.graphInfo.idsInfo,
        showDiff: getGraphParameters(state),
    };
};

const mapDispatchToProps = (dispatch) => {
    return {
        onSelectCryptaId: (cryptaId) => dispatch(selectCryptaId(cryptaId)),
    };
};

export default connect(mapStateToProps, mapDispatchToProps)(InfoPanel);
