import { createAction } from "redux-actions";
import { getIdInfo } from "src/utils/apiClient";

export const requestIdInfo = createAction("id info requested");
export const receiveIdInfo = createAction("id info received");
export const notFoundIdInfo = createAction("id info not found");

export function fetchAdditionalIdInfo(selectedId) {
    return function (dispatch, getState) {
        let key = [selectedId.idValue, selectedId.idType];
        if (getState().idInfo.idsAdditionalInfo[key]) {
            return;
        }

        dispatch(requestIdInfo(selectedId));

        return getIdInfo(selectedId.idValue, selectedId.idType)
            .then((idInfo) => {
                return dispatch(receiveIdInfo({ key: key, idInfo: idInfo.data }));
            })
            .catch((error) => {
                if (error && error.status !== 404) {
                    console.error("Can't fetch id info:", error);
                }

                return dispatch(notFoundIdInfo(selectedId));
            });
    };
}
