
export function edgeName(edge) {
    let source = edge.sourceType + "_" + edge.logSource;
    if (edge.attributes !== undefined && edge.attributes.length !== 0) {
        source += "(";
        let shortenAttrs = edge.attributes.map(attr => {
            if (attr === "indevice") {
                return "IN";
            } else if (attr === "realtime") {
                return "RT";
            } else {
                return attr;
            }
        });
        source += shortenAttrs.join(",");
        source += ")";
    }
    return source;
}