import { handleActions } from "redux-actions";
import { receiveGraph } from "../search/loader/graphActions";
import { notFoundIdInfo, receiveIdInfo, requestIdInfo } from "src/graph/info/actions";

export const graphInfo = handleActions(
    {
        [receiveGraph]: (state, { payload }) => {
            return {
                ...state,
                idsInfo: payload.idsInfo,
                componentsInfo: payload.componentsInfo,
            };
        },
    },
    {
        idsInfo: [],
        componentsInfo: {},
    }
);

export const idInfo = handleActions(
    {
        [receiveIdInfo]: (state, { payload }) => {
            return {
                ...state,
                idsAdditionalInfo: {
                    ...state.idsAdditionalInfo,
                    [payload.key]: payload.idInfo,
                },
            };
        },
        [requestIdInfo]: (state, { payload }) => {
            let key = [payload.idValue, payload.idType];
            return {
                ...state,
                idsAdditionalInfo: {
                    ...state.idsAdditionalInfo,
                    [key]: "Loading...",
                },
            };
        },
        [notFoundIdInfo]: (state, { payload }) => {
            let key = [payload.idValue, payload.idType];
            return {
                ...state,
                idsAdditionalInfo: {
                    ...state.idsAdditionalInfo,
                    [key]: "Not found",
                },
            };
        },
    },
    {
        idsAdditionalInfo: {},
    }
);
