import React, { Component } from "react";
import ActionButton from "../../common/ActionButton";
import FontAwesome from "react-fontawesome";

function copy(content, label) {
    let copyText = document.getElementById("dot-input-" + label);

    if (content.length > 0) {
        copyText.value = content;
    } else {
        copyText.value = "graph is empty";
    }

    copyText.select();
    document.execCommand("copy");

    alert("Copied to clipboard");
}

class CopyDotButton extends Component {
    componentDidMount() {
        // One need to use user generated listener to avoid getting copy permission in Firefox
        document
            .getElementById("copy-dot-button-" + this.props.elementId)
            .addEventListener("click", () => copy(this.props.data, this.props.elementId));
    }

    render() {
        return (
            <div id={"copy-dot-button-" + this.props.elementId}>
                {
                    // Set text area position out of screed due to inability of copying text from hidden element
                }
                <textarea id={"dot-input-" + this.props.elementId} style={{ position: "absolute", left: "-1000px" }} />

                <ActionButton
                    title="Get dot"
                    displayTitle={
                        <div>
                            <FontAwesome name="copy" /> {this.props.hint}
                        </div>
                    }
                />
            </div>
        );
    }
}

export default CopyDotButton;
