import React, { Component } from "react";
import { Select } from "@lib/components/lego";

import "./ValueInput.scss";

class SelectInput extends Component {
    render() {
        return (
            <Select
                width="max"
                size="m"
                view="default"
                value={this.props.value}
                onChange={(event) => this.props.onChange(event.target.value)}
                options={(this.props.items || []).map((item) => ({ value: item, content: item }))}
            />
        );
    }
}

SelectInput.defaultProps = {
    disabled: false,
};

export default SelectInput;
