import React, { Component } from "react";

import { TextInput } from "@lib/components/lego";

import "./ValueInput.scss";

class ValueInput extends Component {
    render() {
        return (
            <div className="graph-value-input">
                <TextInput
                    size="m"
                    view="default"
                    placeholder={this.props.placeholder}
                    value={this.props.value}
                    onChange={(event) => this.props.onChange(event.target.value)}
                    disabled={this.props.disabled}
                    hasClear
                    onClearClick={() => this.props.onChange("")}
                />
            </div>
        );
    }
}

ValueInput.defaultProps = {
    disabled: false,
};

export default ValueInput;
